#pragma once
#include "MySprite.h"
#include "Mario.h"

//GameItems provides a framework for every item present in the game, with different types, sizes and textures specific to each derived item

class GameItems :
	public MySprite
{
public:
	enum BlockType	//Type of blocks
	{
		Invisible,
		Destructable,
		StoredItem,
		Floor,
		Stair,
		Question
	};

	enum StoredItems	//StoredItems that can be in blocks
	{
		StoredCoin,
		StoredPowerUp,
		StoredOneUp,
		StoredNothing
	};

	enum SpriteSize	//Different sizes sprites can be
	{
		Small,
		Medium,
		Big
	};

	static GameItems* currentItem;	//static GameItems pointer for the currentItem
	static bool slideFlag;	//static bool slideFlag for if we should begin the flag slide down the pole

	GameItems();
	~GameItems();

	virtual void update(float dt);	//Virtual update function to be overridden by each GameItem
	virtual void handleCollision(MySprite* sprite, float dt);	//Virtual handleCollision function to be overridden by each GameItem. A generic MySprite is passed, this can be casted as necessary

protected:
	Animation* currentAnimation;	//The currentAnimation for this item
	sf::Texture spriteTexture;	//The current texture for this item
};

